
#Include Once "./Core/Code/Gfx Manip/Gfx Manip.bas"

Declare Sub Gfx_Make_Seamless ( Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

Sub Gfx_Make_Seamless ( Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

	Dim As Long pX = 0, pY = 0
	Dim As Long p1 = 0, p2 = 0, pm1 = 0, pm2 = 0
	Dim As Long pZr = 0, pZg = 0, pZb = 0, pZa = 0, pZ = 0
	
	Dim As FB.Image Ptr Layer1, Layer2
	
	Dim As FB.Image Ptr Mask = LoadRGBAFile ( ".\" & ProjectSpace & "\Code\Assets\Sprites\alpha mask.png" )

	If Dest <> 0 Then ImageDestroy ( Dest )
	
	Dest = ImageCreate ( Source - > Width, Source - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
	Gfx_Buffer_Stretch ( Mask, Dest )
	
	Swap Mask, Dest
	
	ImageDestroy ( Dest )

	Dest = ImageCreate ( Source - > Width, Source - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
		
	Swap Source, Layer1
	
	Layer2 = ImageCreate ( Layer1 - > Width, Layer1 - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
	Put Layer2, ( - ( Layer1 - > Width Shr 1 ), - ( Layer1 - > Height Shr 1 ) ), Layer1, PSet
	
	Put Layer2, ( ( Layer1 - > Width Shr 1 ), - ( Layer1 - > Height Shr 1 ) ), Layer1, PSet
	
	Put Layer2, ( - ( Layer1 - > Width Shr 1 ), - ( Layer1 - > Height Shr 1 ) ), Layer1, PSet
	
	Put Layer2, ( ( Layer1 - > Width Shr 1 ), ( Layer1 - > Height Shr 1	 ) ), Layer1, PSet
	
	For pY = 0 to Layer1 - > Height - 1 Step 1
	For pX = 0 to Layer1 - > Width - 1 Step 1
		
		p1 = Point ( pX, pY, Layer1 )
		p2 = Point ( pX, pY, Layer2 )
		
		pm1 = Point ( pX, pY, Mask )
		pm2 = ( 255 - pm1 )
		
		pZr = ( RGBAr ( p1 ) * pm1 + RGBAr ( p2 ) * pm2 ) \ 255
		pZg = ( RGBAg ( p1 ) * pm1 + RGBAg ( p2 ) * pm2 ) \ 255
		pZb = ( RGBAb ( p1 ) * pm1 + RGBAb ( p2 ) * pm2 ) \ 255
		pZa = ( RGBAa ( p1 ) * pm1 + RGBAa ( p2 ) * pm2 ) \ 255
		
		pZ = RGBA ( pZr, pZg, pZb, pZa )
		
		Pset Dest, ( pX, pY ), pZ
		
	Next pX
	Next PY
	
	ImageDestroy ( Layer1 )
	ImageDestroy ( Layer2 )
	
	ImageDestroy ( Mask )
	
End Sub
